// Fit stpm2 models with varying degrees of freedom
// stored results
//    - rmst at 3 years
//    - mean survival
//    - AIC/BIC
//    - convergence


clear

// change to relavenat folder.
// cd "C:\TSD_simulation\Analysis_of_simulations\stpm2_models"


// program to extract results from stpm2 models
capture program drop get_stpm2_results
program define get_stpm2_results
	syntax, df(string)
	capture drop s3 s80
	
	// rmst3
	capture predict rmst3_df`df', rmst tmax(3)
	if _rc==0{ 
		c_local rmst3_df`df' = rmst3_df`df'[1]
	} 
	else { // estimation did not work, set to missing
		c_local rmst3_df`df' = .
	}
		
	// meansurv
	capture predict meansurv_df`df', rmst tmax(80)
	if _rc==0{
		c_local meansurv_df`df' = meansurv_df`df'[1]
	}
	else { // estimation did not work, set to missing
		c_local meansurv_df`df' = .
	}
	
	// AIC and BIC
	qui count if _d == 1
	capture	estat ic, n(`r(N)')
	if _rc==0 {
		c_local AIC_df`df' = cond(`e(converged)',el(r(S),1,5),.)
		c_local BIC_df`df' = cond(`e(converged)',el(r(S),1,6),.)
	
		// convergence
		c_local converged_df`df' `e(converged)'
	}
	else { // estimation did not work
		c_local AIC_df`df' = .
		c_local BIC_df`df' = .
	
		// convergence set to 0
		c_local converged_df`df' 0
	}
end


// simulation number
local j 1 
// Maximum number of degrees of freedom for fitting an stpm2 model. Code below loops over 1,2,3,...,df_max
local df_max 5

// Scenario
foreach scen in 1 2 3 4 { 
	// sample size 
	foreach ss in  100 500 {

		// Low and medium survival
		foreach S in  1 2 {

		// Different frailty effects
			foreach F in 1 2 {

				// only run if results dataset does not exist
				if(fileexists("Scenario`scen'_S`S'_SS`ss'_F`F'.dta")!=1){
				
					di _newline "Scenario`scen'_S`S'_SS`ss'_F`F'"
					quietly {
						//postfile
						postutil clear
						local newvars
						foreach x in rmst3 meansurv AIC BIC converged {
							foreach df of numlist 1/`df_max' {
								local newvars `newvars' `x'_df`df'
							}
							local newvars `newvars' `x'_dflowestAIC
						}
						local newvars `newvars' df_dflowestAIC
						postfile stpm2sim `newvars' using Scenario`scen'_S`S'_SS`ss'_F`F'.dta,replace
					
						// loop over datasets
						forvalues j = 1/1000 {
							// load and analyse
							use ../../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/sim`j', clear
							stset t d
							clonevar old_t = _t				
							foreach df of numlist 1/`df_max' {
								// fit model and get results
								capture stpm2 , df(`df') scale(hazard)
								if _rc!=0{ // estimation did not work, try with different initial values
									capture stpm2 , df(`df') scale(hazard) lininit
								} 
								get_stpm2_results, df(`df')
							}
						
							// results for model with lowest AIC
							scalar minAIC = 9999999 // some large number
							foreach df of numlist 1/`df_max' {
								if `AIC_df`df'' < minAIC {
									scalar minAIC = `AIC_df`df''
									foreach x in rmst3 meansurv AIC BIC converged {
										local `x'_dflowestAIC = ``x'_df`df''
									}
									local df_dflowestAIC = `df'
								}
							}
				
							// post values
							local postvals
							foreach x in rmst3 meansurv AIC BIC converged {
								foreach df of numlist 1/`df_max' {
									local postvals `postvals' (``x'_df`df'')
								}
								local postvals `postvals' (``x'_dflowestAIC')
							}
							local postvals `postvals' (`df_dflowestAIC')
							di "`postvals'"
							post stpm2sim `postvals'
							noisily di "." _continue
						}
						postclose stpm2sim
					}
				}
			}
		}
	}
}


